<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;

class OrderPlacedNotification implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $order;
    public $creator_id;

    public function __construct($order, $creator_id)
    {
        $this->order = $order;
        $this->creator_id = $creator_id;
    }

    // Notify the content creator of the specific gig
    public function broadcastOn()
    {
        return new Channel('creator.' . $this->creator_id);
    }

    public function broadcastAs()
    {
        return 'order.placed';
    }

    // Data sent with the notification
    public function broadcastWith()
    {
        return [
            'buyer_name' => $this->order->buyer_name,
            'email' => $this->order->email,
            'project_details' => $this->order->project_details,
            'budget' => $this->order->budget,
            'expected_delivery_date' => $this->order->expected_delivery_date,
            'gig_id' => $this->order->gig_id,
        ];
    }
}
