<?php
namespace App\Jobs;

use App\Models\Message;
use App\Models\Order;
use App\Models\User;

class SendMessageJob extends Job
{
    public $orderId;
    public $senderId;
    public $receiverId;
    public $messageContent;

    // Constructor to receive the parameters when the job is dispatched
    public function __construct($orderId, $senderId, $receiverId, $messageContent)
    {
        $this->orderId = $orderId;
        $this->senderId = $senderId;
        $this->receiverId = $receiverId;
        $this->messageContent = $messageContent;
    }

    // This method handles the logic of what the job does
    public function handle()
    {
        // Create the message in the database
        Message::create([
            'order_id' => $this->orderId,
            'sender_id' => $this->senderId,
            'receiver_id' => $this->receiverId,
            'message' => $this->messageContent,
        ]);
    }
}
    