<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ContentCreator extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'instagram_handle',
        'instagram_followers',
        'youtube_channel',
        'youtube_subscribers',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }


    /**
     * A content creator can have many stories
     */
    public function stories()
    {
        return $this->hasMany(Story::class);
    }

    /**
     * Check if the content creator is eligible to post stories
     */
    public function isEligible()
    {
        return $this->instagram_followers >= 1000 || $this->youtube_subscribers >= 1000;
    }




}
