<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use HasFactory;

    // Define the table if it's not the plural form of the model name
    protected $table = 'transactions';

    // Define the fillable fields (to allow mass assignment)
    protected $fillable = [
        'user_id',
        'plan',
        'payment_intent_id',
        'amount',
        'currency',
        'status',
    ];

    public static function createPending($userId, $plan, $intentId, $amount, $currency)
{
    return self::create([
        'user_id' => $userId,
        'plan' => $plan,
        'payment_intent_id' => $intentId,
        'amount' => $amount,
        'currency' => $currency,
        'status' => 'pending',
    ]);
}

    public function user()
    {
        return $this->belongsTo(User::class);
    }

}
