<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Database\Seeders\StorySeeder;

class CreateStoriesTable extends Migration
{
    public function up(): void
    {
        // Create the stories table
        Schema::create('stories', function (Blueprint $table) {
            $table->id();
            $table->foreignId('content_creator_id')->constrained()->onDelete('cascade');
            $table->string('media_path');
            $table->string('caption')->nullable();
            $table->timestamp('expires_at')->nullable();
            $table->timestamps();
        });

        // Call the StorySeeder to insert dummy data after the table is created
        // (new StorySeeder())->run();
    }

    public function down(): void
    {
        // Drop the stories table if this migration is rolled back
        Schema::dropIfExists('stories');
    }
}


        // echo "Stories seeded successfully!\n";