<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\BuyerProfile; // use your Profile model
use App\Models\User;

class BuyerProfileSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // First create buyers (users with role Buyer)
        $buyers = [
            [
                'name' => 'ahad',
                'email' => 'ahad@example.com',
                'password' => bcrypt('password'),
            ],
            [
                'name' => 'asim',
                'email' => 'asim@example.com',
                'password' => bcrypt('password'),
            ],
        ];

        foreach ($buyers as $buyerData) {
            $user = User::create($buyerData);
            $user->assignRole('Buyer');

            // Create corresponding profile
            $user->buyerProfile()->create([
                'contact_number' => '1234567890',
                'about' => 'This is the about section for ' . $user->name,
            ]);
        }
    }
}