<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\SocialAuthController;
use App\Http\Controllers\StripePaymentController;
use App\Http\Controllers\GigController;
use App\Http\Controllers\CreatorProfileController;
use App\Http\Controllers\StoryController;
use App\Http\Controllers\BuyerProfileController;
use App\Http\Controllers\CreatorServiceController;
use App\Http\Controllers\ChatController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\OrderController;
    
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('/register', [AuthController::class, 'register']);
Route::post('/login',    [AuthController::class, 'login']);
Route::post('/logout',   [AuthController::class, 'logout']);
Route::get('/email/verify/{id}/{hash}', [AuthController::class, 'verifyEmail'])->name('verification.verify');

// Google/Facebook Login
Route::post('/social-login', [SocialAuthController::class, 'handleSocialLogin']);

Route::post('/create-payment-intent', [StripePaymentController::class, 'createPaymentIntent']);
// Route::post('stripe/webhook', [StripeController::class, 'handleWebhook']);
Route::middleware(['auth:sanctum'])->get('/creator-home/{id}', [AuthController::class, 'creatorHome']);


Route::middleware('auth:sanctum')->group(function () {
    Route::get('/gigs/details', [GigController::class, 'index']);
    Route::post('/gigs', [GigController::class, 'store']);
    Route::get('/gigs/{id}', [GigController::class, 'show']);
    Route::put('/gigs/{id}', [GigController::class, 'update']);
    Route::delete('/gigs/{id}', [GigController::class, 'destroy']);
    // Route::patch('/gigs/{id}/favorite', [GigController::class, 'toggleFavorite']);
    Route::post('/gigs/{id}/toggle-favorite', [GigController::class, 'toggleFavorite']);

    Route::post('/gigs/filter', [GigController::class, 'filterGigs']);
    Route::get('/gigs/filters', [GigController::class, 'getFilters']);


    Route::post('/gigs/check-filter', [GigController::class, 'checkFilterExists']);

});


    // Route::middleware(['auth:sanctum', 'verified'])->group(function () {
    //     Route::get('/creator-profile', [CreatorProfileController::class, 'show']);
    //     Route::post('/creator-profile', [CreatorProfileController::class, 'storeOrUpdate']);

    //     Route::post('/skills', [CreatorProfileController::class, 'addSkill']);
    //     Route::put('/skills/{id}', [CreatorProfileController::class, 'updateSkill']);
    //     Route::delete('/skills/{id}', [CreatorProfileController::class, 'deleteSkill']);

    //     Route::delete('/creator-profile', [CreatorProfileController::class, 'destroy']);

    // });



    Route::middleware(['auth:sanctum', 'verified'])->group(function () {
        Route::get('/creator-profile/{id}', [CreatorProfileController::class, 'show']);
        // Route::put('/creator-profile/{id}', [CreatorProfileController::class, 'storeOrUpdate']);

        Route::post('/creator-profile', [CreatorProfileController::class, 'store']);   // For creating profile
        Route::put('/creator-profile/{id}', [CreatorProfileController::class, 'update']); // For updating profile

        Route::delete('/creator-profile/{id}', [CreatorProfileController::class, 'destroy']);

        Route::post('/skills', [CreatorProfileController::class, 'addSkill']);
        Route::put('/skills/{id}', [CreatorProfileController::class, 'updateSkill']);
        Route::delete('/skills/{id}', [CreatorProfileController::class, 'deleteSkill']);


    });


    Route::middleware('auth:sanctum')->group(function () {
        // Create a new service
        Route::post('/creator/services', [CreatorServiceController::class, 'store']);

        // Get all services for the logged-in creator
        Route::get('/creator/services', [CreatorServiceController::class, 'index']);

        // Update an existing service
        Route::put('/creator/services/{id}', [CreatorServiceController::class, 'update']);

        // Delete a service
        Route::delete('/creator/services/{id}', [CreatorServiceController::class, 'destroy']);

        Route::post('/services/search', [CreatorServiceController::class, 'search']);
        Route::get('/services/recommendations', [CreatorServiceController::class, 'getRecommendations']);

    });


    Route::middleware('auth:sanctum')->group(function
     () {
        Route::get('/stories', [StoryController::class, 'index']);          // View others' stories
        Route::post('/stories', [StoryController::class, 'store']);         // Upload story
        Route::delete('/stories/{id}', [StoryController::class, 'destroy']); // Delete own story
    });



Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return response()->json($request->user());
});



// ------------------- Buyer --------------------


Route::middleware('auth:sanctum')->group(function () {
    Route::get('/buyer/content', [GigController::class, 'buyerDashboard']);
    Route::get('/gigs/{id}', [GigController::class, 'showInBuyer']);

});

Route::middleware('auth:sanctum')->group(function () {
    Route::post('/buyer-profile', [BuyerProfileController::class, 'store']);
    Route::get('/buyer-profile/{id}', [BuyerProfileController::class, 'show']);
    Route::put('/buyer-profile/{id}', [BuyerProfileController::class, 'update']);
    Route::delete('/buyer-profile/{id}', [BuyerProfileController::class, 'destroy']);
});
Route::middleware('auth:sanctum')->post('/orders', [App\Http\Controllers\OrderController::class, 'store']);

Route::post('/send-notification', [NotificationController::class, 'send']);
Route::middleware('auth:sanctum')->group(function () {
    Route::get('/notifications', [NotificationController::class, 'index']);
    Route::put('/notifications/{id}/read', [NotificationController::class, 'markAsRead']);
});

Route::middleware('auth:sanctum')->post('/orders/{orderId}/respond', [OrderController::class, 'respondToOrder']);

Route::middleware('auth:sanctum')->get('/creator/my-orders', [OrderController::class, 'myOrders']);
Route::middleware('auth:sanctum')->post('/creator/order/{orderId}/update', [OrderController::class, 'updateOrderDetails']);

Route::middleware('auth:sanctum')->group(function () {
    Route::patch('/orders/{id}/milestone', [OrderController::class, 'updateMilestone']);
    Route::patch('/orders/{id}/progress-status', [OrderController::class, 'updateProgressStatus']);
});

Route::middleware('auth:sanctum')->group(function () {
    Route::post('orders/{order_id}/message', [OrderController::class, 'sendMessageToBuyer']);
    Route::post('/orders/{id}/send-reply', [OrderController::class, 'sendMessageToSeller']);

    Route::post('/orders/{id}/upload-work', [OrderController::class, 'uploadWork']);
    Route::get('/orders/{id}/view-submissions', [OrderController::class, 'viewSubmission']);

});

Route::middleware('auth:sanctum')->group(function () {
    Route::get('/order/{orderId}', [OrderController::class, 'showOrderForBuyer']); // View order details
    Route::get('/notifications', [NotificationController::class, 'getNotificationsForBuyer']); // View notifications
    Route::get('/order/{orderId}/progress', [OrderController::class, 'getOrderProgressForBuyer']); // View order progress
});

Route::middleware('auth:api')->get('/order/{orderId}', [OrderController::class, 'getOrderDetails']);

Route::middleware('auth:sanctum')->prefix('buyer')->group(function () {
    Route::get('/all/orders', [OrderController::class, 'getMyOrders']);
});



Route::middleware('auth:api')->group(function () {
    Route::post('/messages/send', [ChatController::class, 'sendMessage']);
    Route::get('/messages/{receiverId}', [ChatController::class, 'getMessages']);
});




