<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\CreatorService;

class CreatorProfile extends Model
{
    protected $fillable = ['user_id', 'expertise', 'about_me'];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function skills() {
        return $this->hasMany(Skill::class);
    }

    public function services() {
        return $this->hasMany(CreatorService::class);
    }
}
