<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Gig extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'label',
        'description',
        'media_path',
        'starting_price',
        'rating',
        'review',
        'is_favorite',
    ];

    protected $casts = [
        'starting_price' => 'decimal:2',
        'rating'         => 'float',
        'review'         => 'integer',
        'is_favorite'    => 'boolean',
    ];



    // Relationship: Gig belongs to a User
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Accessor: Get full URL for media
    public function getMediaUrlAttribute()
    {
        return $this->media_path
            ? asset('storage/' . $this->media_path)
            : null;
    }

}
