<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Support\Str;
use App\Models\CreatorProfile;
class User extends Authenticatable implements MustVerifyEmail
{
    use HasApiTokens, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];

    public function transactions()
    {
        return $this->hasMany(Transaction::class);
    }

    public function gigs()
    {
        return $this->hasMany(Gig::class);
    }
    // public function contentCreator()
    // {
    //     return $this->hasOne(ContentCreator::class);
    // }

    // public function hasRole($role)
    // {
    //     return Str::contains($this->role, $role);
    // }
    public function buyerProfile()
{
    return $this->hasOne(BuyerProfile::class);
}

public function creatorProfile() {
    return $this->hasOne(CreatorProfile::class);
}


}
