<?php

namespace Database\Seeders;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\User;
use App\Models\Chat;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // \App\Models\User::factory(10)->create();

        // \App\Models\User::factory()->create([
        //     'name' => 'Test User',
        //     'email' => 'test@example.com',
        // ]);

        $user1 = User::create([
            'name' => 'Content Creator',
            'email' => 'shancreator@gmail.com',
            'password' => bcrypt('password')
        ]);

        $user2 = User::create([
            'name' => 'Buyer',
            'email' => 'shaebuyer@example.com',
            'password' => bcrypt('password')
        ]);

        // Create dummy chat messages between them
        Chat::create([
            'sender_id' => $user1->id,
            'receiver_id' => $user2->id,
            'message' => 'Hello, Buyer!',
        ]);

        Chat::create([
            'sender_id' => $user2->id,
            'receiver_id' => $user1->id,
            'message' => 'Hi, Content Creator!',
        ]);

        $this->call([
            StorySeeder::class,
            CreatorProfileSeeder::class,
            GigSeeder::class,
        ]);
        

        $this->call(StorySeeder::class);
        $this->call([
            CreatorProfileSeeder::class,
        ]);

        Permission::create(['name' => 'create post']);
        Permission::create(['name' => 'edit post']);
        Permission::create(['name' => 'delete post']);

        // Create roles
        $admin = Role::create(['name' => 'admin']);
        $editor = Role::create(['name' => 'editor']);

        // Assign permissions to roles
        $admin->givePermissionTo('create post', 'edit post', 'delete post');
        $editor->givePermissionTo('create post', 'edit post');

        // Assign roles to users
        $user = \App\Models\User::find(1);
        $user->assignRole('admin');
    }



}
